function [new_array,noidx] = rmv_duplicate(array,col)
%This function will remove any duplicate vertices for puncta analysis
%Synatax:   [new_array] = rmv_duplicate(array,[1 2 3]); 
%Input:     array = the array to be compressed
%           col = the columns used to determine duplication. [1 3 5] = use
%                   column 1, 3 and 5, and if they are all duplicated,
%                   remove the vertices. Note: for now the col variable can
%                   only be 3 columns max.
%Output:    new_array = the collapsed array with no duplicates
%           noidx = a logical array that is true where there is a value
%                   that is duplicated, thus removed.
%Note: the vertices array must have three columns each being x y z.

%create the no index
noidx = false(size(array,1),1);
%create the comparision array
array_tmp = array(:,col);

for i = 1:size(array,1)     %step through the number of vertices
    noidx_tmp = false(size(array,1),3);
    for j = 1:size(col,2)       %step through the columns
        [y,x] = find(array_tmp(:,j)==array(i,col(j)));  %look for repeats in each column
        noidx_tmp(y,j) = 1;     %hold each detected repeat in a temporary logical array
    end
    %create one temporary array where true is only where all three columns
    %are duplicated
    noidx_tmp = logical(prod(single(noidx_tmp),2));
    [x] = find(noidx_tmp==1);     %see if there are more than 1 duplicate.  1 is expected always.
    if size(x,1) > 1
        noidx(x(2:end)) = 1;   %set the other points to be deleted
        array_tmp(x,:) = nan(size(x,1),3);    %remove from array_tmp
    end
end

clear array_tmp

%now remove the duplicate data
new_array = array(~noidx,:);
